/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8230.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8230.DeviceView.ChassisLike;
import ibm.nways.jdm8230.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8230.DeviceView.ModuleLike;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class RLam
implements ModuleLike {
    protected int numberOfPorts;
    protected GraphicImage rLamGraphicImage;
    protected int rLamType;
    protected Point location;
    protected int slot;
    protected GraphicContainer graphicContainer;
    protected GraphicContainer rLamContainer = new GraphicContainer();
    private Vector components = new Vector();
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8230.DeviceView.GraphicResources";
    protected static ResourceBundle resources = ResourceBundle.getBundle("ibm.nways.jdm8230.DeviceView.GraphicResources");
    protected static final String SER_PATH = "ibm.nways.jdm8230.WCDefault";
    protected static final String DEST_PANEL = "ibm.nways.jdm8230.eui.RemoteLamPanel";
    protected static final int COOKIE_FLAGS = 20;
    protected String cookieID;
    protected GenModel rLamTableModel;
    protected GenModel portTableModel;
    protected JdmBrowser jdmBrowser;
    protected ChassisLike chassis;
    public static final int UNKNOWN = 1;
    public static final int NO_RLAM_DETECTED = 2;
    public static final int PASSIVE_RLAM = 3;
    public static final int ACTIVE_RLAM = 4;
    protected static final String[] RLAM_TYPE = new String[]{"RLam_Unknown", "RLam_NotDetected", "RLam_Passive", "RLam_Active"};

    public void dispose() {
        if (this.graphicContainer != null) {
            this.graphicContainer.dispose();
            this.graphicContainer = null;
        }
        if (this.rLamContainer != null) {
            this.rLamContainer.dispose();
            this.rLamContainer = null;
        }
        this.rLamGraphicImage = null;
        this.location = null;
        this.rLamTableModel = null;
        this.portTableModel = null;
        this.jdmBrowser = null;
        this.chassis = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
    }

    public void draw() {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                RAS.logInformation(19, 4, this, "draw", "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                RAS.logException(19, 4, this, "draw", exception);
            }
        }
        this.graphicContainer.add(this.rLamContainer);
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public GenModel getModel() {
        block2: {
            if (this.rLamTableModel != null) break block2;
            try {
                GenModel genModel = (GenModel)this.jdmBrowser.getModel();
                genModel = (GenModel)genModel.getComponent("ConfigurationFolder");
                genModel = (GenModel)genModel.getComponent("SystemFolder");
                genModel = (GenModel)genModel.getComponent("DeviceFolder");
                this.rLamTableModel = (GenModel)genModel.getComponent("RLamFolder");
            }
            catch (Exception exception) {
                RAS.logException(19, 4, this, "getModel", exception);
            }
        }
        return this.rLamTableModel;
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.CauRemoteLamLiuModLocation", new Integer(this.slot));
        return modelInfo;
    }

    public String getDestinationPanel() {
        return DEST_PANEL;
    }

    public final void setCommonInformation(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, GenModel genModel2, int n, GraphicContainer graphicContainer) {
        this.chassis = chassisLike;
        this.jdmBrowser = jdmBrowser;
        this.rLamTableModel = genModel;
        this.portTableModel = genModel2;
        this.slot = n;
        this.graphicContainer = graphicContainer;
    }

    public I18NMsgFormat getFlyOverText() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(this.slot);
        String string = "RLam_Unknown";
        try {
            string = RLAM_TYPE[this.rLamType - 1];
        }
        catch (Exception exception) {
            RAS.logWarning(19, 4, this, "gettFlyOverText", "Cannot find fly-over for RLam type -> " + this.rLamType);
            RAS.logException(19, 4, this, "getFlyOverText", exception);
        }
        objectArray[1] = resources.getString(string);
        return new I18NMsgFormat(BUNDLE_NAME, "RLam", objectArray);
    }

    public void setSpecificInformation() {
    }

    public void discoverChildren() {
    }

    public final void setLocation(Point point) {
        this.location = point;
        this.rLamContainer.setLocation(this.location.x, this.location.y);
    }
}

